/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.inventory.CartographyTableScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.CartographyContainer;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmClientModule;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.handler.ModuleHandler;
import svenhjol.charm.container.AtlasInventory;
import svenhjol.charm.gui.AtlasScreen;
import svenhjol.charm.module.Atlas;
import svenhjol.charm.render.AtlasRenderer;

public class AtlasClient
extends CharmClientModule {
    private AtlasRenderer renderer;

    public AtlasClient(CharmModule module) {
        super(module);
    }

    @Override
    public void register() {
        ScreenManager.func_216911_a(Atlas.CONTAINER, AtlasScreen::new);
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.func_77973_b() == Atlas.ATLAS_ITEM) {
            if (this.renderer == null) {
                this.renderer = new AtlasRenderer();
            }
            this.renderer.renderAtlas(event.getMatrixStack(), event.getBuffers(), event.getLight(), event.getHand(), event.getEquipProgress(), event.getSwingProgress(), itemStack);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b() || stack.func_77973_b() != Atlas.ATLAS_ITEM) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player == null) {
            return;
        }
        AtlasInventory inventory = Atlas.getInventory(player.field_70170_p, stack);
        event.getToolTip().add(new StringTextComponent("Scale " + inventory.getScale()).func_240699_a_(TextFormatting.GRAY));
        ItemStack map = inventory.getLastActiveMapItem();
        if (map == null) {
            return;
        }
        IFormattableTextComponent name = map.func_82837_s() ? map.func_200301_q().func_230532_e_() : map.func_200301_q().func_230532_e_().func_230529_a_((ITextComponent)new StringTextComponent(" #" + FilledMapItem.func_195949_f((ItemStack)map)));
        event.getToolTip().add(name.func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
    }

    public static void updateInventory(int atlasSlot) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack atlas = player.field_71071_by.func_70301_a(atlasSlot);
        Atlas.getInventory((World)mc.field_71441_e, atlas).reload(atlas);
    }

    public static boolean shouldDrawAtlasCopy(CartographyTableScreen screen) {
        return ModuleHandler.enabled(Atlas.class) && ((CartographyContainer)screen.func_212873_a_()).func_75139_a(0).func_75211_c().func_77973_b() == Atlas.ATLAS_ITEM && ((CartographyContainer)screen.func_212873_a_()).func_75139_a(1).func_75211_c().func_77973_b() == Items.field_151148_bJ;
    }
}

